/*
 * Globalize Culture ja
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * This file was generated by the Globalize Culture Generator
 * Translation: bugs found in this file need to be fixed in the generator
 */

(function( window, undefined ) {

var Globalize;

if ( typeof require !== "undefined" &&
	typeof exports !== "undefined" &&
	typeof module !== "undefined" ) {
	// Assume CommonJS
	Globalize = require( "globalize" );
} else {
	// Global variable
	Globalize = window.Globalize;
}

Globalize.addCultureInfo( "ja", "default", {
	name: "ja",
	englishName: "Japanese",
	nativeName: "日本語",
	language: "ja",
	numberFormat: {
		"NaN": "NaN (非数値)",
		negativeInfinity: "-∞",
		positiveInfinity: "+∞",
		percent: {
			pattern: ["-n%","n%"]
		},
		currency: {
			pattern: ["-$n","$n"],
			decimals: 0,
			symbol: "¥"
		}
	},
	calendars: {
		standard: {
			days: {
				names: ["日曜日","月曜日","火曜日","水曜日","木曜日","金曜日","土曜日"],
				namesAbbr: ["日","月","火","水","木","金","土"],
				namesShort: ["日","月","火","水","木","金","土"]
			},
			months: {
				names: ["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月",""],
				namesAbbr: ["1","2","3","4","5","6","7","8","9","10","11","12",""]
			},
			AM: ["午前","午前","午前"],
			PM: ["午後","午後","午後"],
			eras: [{"name":"西暦","start":null,"offset":0}],
			patterns: {
				d: "yyyy/MM/dd",
				D: "yyyy'年'M'月'd'日'",
				t: "H:mm",
				T: "H:mm:ss",
				f: "yyyy'年'M'月'd'日' H:mm",
				F: "yyyy'年'M'月'd'日' H:mm:ss",
				M: "M'月'd'日'",
				Y: "yyyy'年'M'月'"
			}
		},
		Japanese: {
			name: "Japanese",
			days: {
				names: ["日曜日","月曜日","火曜日","水曜日","木曜日","金曜日","土曜日"],
				namesAbbr: ["日","月","火","水","木","金","土"],
				namesShort: ["日","月","火","水","木","金","土"]
			},
			months: {
				names: ["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月",""],
				namesAbbr: ["1","2","3","4","5","6","7","8","9","10","11","12",""]
			},
			AM: ["午前","午前","午前"],
			PM: ["午後","午後","午後"],
			eras: [{"name":"平成","start":null,"offset":1867},{"name":"昭和","start":-1812153600000,"offset":1911},{"name":"大正","start":-1357603200000,"offset":1925},{"name":"明治","start":60022080000,"offset":1988}],
			twoDigitYearMax: 99,
			patterns: {
				d: "gg y/M/d",
				D: "gg y'年'M'月'd'日'",
				t: "H:mm",
				T: "H:mm:ss",
				f: "gg y'年'M'月'd'日' H:mm",
				F: "gg y'年'M'月'd'日' H:mm:ss",
				M: "M'月'd'日'",
				Y: "gg y'年'M'月'"
			}
		}
	}
});

}( this ));
(function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}
var dict = {
  "box user": "ユーザー",
  "filetype_box user": "ユーザー",
  "html": "HTMLファイル",
  "filetype_html": "HTMLファイル",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "ウェブページ",
  "filetype_webscraperwebpage": "ウェブページ",
  "image": "画像",
  "filetype_image": "画像",
  "folder": "フォルダ",
  "filetype_folder": "フォルダ",
  "txt": "テキスト",
  "filetype_txt": "テキスト",
  "zip": "Zipファイル",
  "filetype_zip": "Zipファイル",
  "olefile": "OLEファイル",
  "filetype_olefile": "OLEファイル",
  "gmailmessage": "Gmailメッセージ",
  "filetype_gmailmessage": "Gmailメッセージ",
  "pdf": "PDFファイル",
  "filetype_pdf": "PDFファイル",
  "swf": "Flashファイル",
  "filetype_swf": "Flashファイル",
  "xml": "XMLファイル",
  "filetype_xml": "XMLファイル",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "RSSフィード",
  "filetype_rssitem": "RSSフィード",
  "doc": "ドキュメント",
  "filetype_doc": "ドキュメント",
  "docx": "Microsoft Wordドキュメント",
  "filetype_docx": "Microsoft Wordドキュメント",
  "xls": "スプレッドシートドキュメント",
  "filetype_xls": "スプレッドシートドキュメント",
  "ppt": "プレゼンテーションドキュメント",
  "filetype_ppt": "プレゼンテーションドキュメント",
  "video": "ビデオ",
  "filetype_video": "ビデオ",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "Open Textドキュメント",
  "filetype_odt": "Open Textドキュメント",
  "lithiummessage": "Lithiumメッセージ",
  "filetype_lithiummessage": "Lithiumメッセージ",
  "lithiumthread": "Lithiumスレッド",
  "filetype_lithiumthread": "Lithiumスレッド",
  "lithiumboard": "Lithiumボード",
  "filetype_lithiumboard": "Lithiumボード",
  "lithiumcategory": "Lithiumカテゴリ",
  "filetype_lithiumcategory": "Lithiumカテゴリ",
  "lithiumcommunity": "Lithiumコミュニティ",
  "filetype_lithiumcommunity": "Lithiumコミュニティ",
  "people": "ユーザー",
  "objecttype_people": "ユーザー",
  "message": "メッセージ",
  "objecttype_message": "メッセージ",
  "feed": "RSSフィード",
  "objecttype_feed": "RSSフィード",
  "thread": "スレッド",
  "objecttype_thread": "スレッド",
  "file": "ファイル",
  "objecttype_file": "ファイル",
  "board": "ボード",
  "objecttype_board": "ボード",
  "category": "カテゴリ",
  "objecttype_category": "カテゴリ",
  "account": "アカウント",
  "objecttype_account": "アカウント",
  "annotation": "注",
  "objecttype_annotation": "注",
  "campaign": "キャンペーン",
  "objecttype_campaign": "キャンペーン",
  "case": "ケース",
  "objecttype_case": "ケース",
  "contact": "連絡先",
  "objecttype_contact": "連絡先",
  "contract": "契約",
  "objecttype_contract": "契約",
  "event": "イベント",
  "objecttype_event": "イベント",
  "email": "電子メール",
  "objecttype_email": "電子メール",
  "goal": "目標",
  "objecttype_goal": "目標",
  "objecttype_incident": "ケース",
  "invoice": "請求書",
  "objecttype_invoice": "請求書",
  "lead": "リード",
  "objecttype_lead": "リード",
  "list": "リスト",
  "objecttype_list": "マーケティングリスト",
  "solution": "ソリューション",
  "objecttype_solution": "ソリューション",
  "task": "タスク",
  "objecttype_task": "タスク",
  "user": "ユーザー",
  "objecttype_user": "ユーザー",
  "attachment": "添付",
  "objecttype_attachment": "添付",
  "casecomment": "ケースコメント",
  "objecttype_casecomment": "ケースコメント",
  "opportunity": "提案",
  "objecttype_opportunity": "提案",
  "opportunityproduct": "提案製品",
  "objecttype_opportunityproduct": "提案製品",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "注",
  "objecttype_note": "注",
  "product": "製品",
  "objecttype_product": "製品",
  "partner": "パートナー",
  "objecttype_partner": "パートナー",
  "queueitem": "キューアイテム",
  "objecttype_queueitem": "キューアイテム",
  "quote": "見積もり",
  "objecttype_quote": "見積もり",
  "salesliterature": "営業資料",
  "objecttype_salesliterature": "営業資料",
  "salesorder": "販売注文",
  "objecttype_salesorder": "販売注文",
  "service": "サービス",
  "objecttype_service": "サービス",
  "socialprofile": "ソーシャルプロファイル",
  "objecttype_socialprofile": "ソーシャルプロファイル",
  "kbdocumentation": "文書",
  "objecttype_kbdocumentation": "文書",
  "kbtechnicalarticle": "文書",
  "objecttype_kbtechnicalarticle": "文書",
  "kbsolution": "ソリューション",
  "objecttype_kbsolution": "ソリューション",
  "kbknowledgearticle": "ナレッジ記事",
  "objecttype_kbknowledgearticle": "ナレッジ記事",
  "kbattachment": "添付",
  "objecttype_kbattachment": "添付",
  "kbarticle": "記事",
  "objecttype_kbarticle": "記事",
  "kbarticlecomment": "記事のコメント",
  "objecttype_kbarticlecomment": "記事のコメント",
  "knowledgearticle": "ナレッジ記事",
  "objecttype_knowledgearticle": "ナレッジ記事",
  "topic": "トピック",
  "objecttype_topic": "トピック",
  "dashboard": "ダッシュボード",
  "objecttype_dashboard": "ダッシュボード",
  "contentversion": "ドキュメント",
  "objecttype_contentversion": "ドキュメント",
  "collaborationgroup": "コラボレーショングループ",
  "objecttype_collaborationgroup": "コラボレーショングループ",
  "spportal": "ポータル",
  "filetype_spportal": "ポータル",
  "spsite": "サイト",
  "filetype_spsite": "サイト",
  "spuserprofile": "SharePointユーザー",
  "filetype_spuserprofile": "SharePointユーザー",
  "sparea": "エリア",
  "filetype_sparea": "エリア",
  "spannouncement": "通知",
  "filetype_spannouncement": "通知",
  "spannouncementlist": "通知",
  "filetype_spannouncementlist": "通知",
  "spcontact": "連絡先",
  "filetype_spcontact": "連絡先",
  "spcontactlist": "連絡先",
  "filetype_spcontactlist": "連絡先",
  "spcustomlist": "カスタムリスト",
  "filetype_spcustomlist": "カスタムリスト",
  "spdiscussionboard": "ディスカッションボード",
  "filetype_spdiscussionboard": "ディスカッションボード",
  "spdiscussionboardlist": "ディスカッションボード",
  "filetype_spdiscussionboardlist": "ディスカッションボード",
  "spdocumentlibrarylist": "ドキュメントライブラリ",
  "filetype_spdocumentlibrarylist": "ドキュメントライブラリ",
  "spevent": "イベント",
  "filetype_spevent": "イベント",
  "speventlist": "イベント",
  "filetype_speventlist": "イベント",
  "spformlibrarylist": "ライブラリから",
  "filetype_spformlibrarylist": "ライブラリから",
  "spissue": "問題",
  "filetype_spissue": "問題",
  "spissuelist": "問題",
  "filetype_spissuelist": "問題",
  "splink": "リンク",
  "filetype_splink": "リンク",
  "splinklist": "リンク",
  "filetype_splinklist": "リンク",
  "sppicturelibrarylist": "画像ライブラリ",
  "filetype_sppicturelibrarylist": "画像ライブラリ",
  "spsurvey": "調査",
  "filetype_spsurvey": "調査",
  "spsurveylist": "調査",
  "filetype_spsurveylist": "調査",
  "sptask": "タスク",
  "filetype_sptask": "タスク",
  "sptasklist": "タスク",
  "filetype_sptasklist": "タスク",
  "spagenda": "議題",
  "filetype_spagenda": "議題",
  "spagendalist": "議題",
  "filetype_spagendalist": "議題",
  "spattendee": "出席者",
  "filetype_spattendee": "出席者",
  "spattendeelist": "出席者",
  "filetype_spattendeelist": "出席者",
  "spcustomgridlist": "カスタムグリッド",
  "filetype_spcustomgridlist": "カスタムグリッド",
  "spdecision": "決定",
  "filetype_spdecision": "決定",
  "spdecisionlist": "決定",
  "filetype_spdecisionlist": "決定",
  "spobjective": "目的",
  "filetype_spobjective": "目的",
  "spobjectivelist": "目的",
  "filetype_spobjectivelist": "目的",
  "sptextbox": "テキストボックス",
  "filetype_sptextbox": "テキストボックス",
  "sptextboxlist": "テキストボックスリスト",
  "filetype_sptextboxlist": "テキストボックスリスト",
  "spthingstobring": "持参物",
  "filetype_spthingstobring": "持参物",
  "spthingstobringlist": "持参物",
  "filetype_spthingstobringlist": "持参物",
  "sparealisting": "エリアの一覧",
  "filetype_sparealisting": "エリアの一覧",
  "spmeetingserie": "関連する会議",
  "filetype_spmeetingserie": "関連する会議",
  "spmeetingserielist": "関連する会議のリスト",
  "filetype_spmeetingserielist": "関連する会議のリスト",
  "spsitedirectory": "サイトディレクトリ項目",
  "filetype_spsitedirectory": "サイトディレクトリ項目",
  "spsitedirectorylist": "サイトディレクトリ",
  "filetype_spsitedirectorylist": "サイトディレクトリ",
  "spdatasource": "データソース",
  "filetype_spdatasource": "データソース",
  "spdatasourcelist": "データソースリスト",
  "filetype_spdatasourcelist": "データソースリスト",
  "splisttemplatecataloglist": "リストテンプレートギャラリー",
  "filetype_splisttemplatecataloglist": "リストテンプレートギャラリー",
  "spwebpartcataloglist": "Webパーツギャラリー",
  "filetype_spwebpartcataloglist": "Webパーツギャラリー",
  "spwebtemplatecataloglist": "サイトテンプレートギャラリー",
  "filetype_spwebtemplatecataloglist": "サイトテンプレートギャラリー",
  "spworkspacepagelist": "ワークスペースページ",
  "filetype_spworkspacepagelist": "ワークスペースページ",
  "spunknownlist": "カスタムリスト",
  "filetype_spunknownlist": "カスタムリスト",
  "spadministratortask": "管理者タスク",
  "filetype_spadministratortask": "管理者タスク",
  "spadministratortasklist": "管理者タスク",
  "filetype_spadministratortasklist": "管理者タスク",
  "spareadocumentlibrarylist": "エリアドキュメントライブラリ",
  "filetype_spareadocumentlibrarylist": "エリアドキュメントライブラリ",
  "spblogcategory": "ブログカテゴリ",
  "filetype_spblogcategory": "ブログカテゴリ",
  "spblogcategorylist": "ブログカテゴリ",
  "filetype_spblogcategorylist": "ブログカテゴリ",
  "spblogcomment": "ブログコメント",
  "filetype_spblogcomment": "ブログコメント",
  "spblogcommentlist": "ブログコメント",
  "filetype_spblogcommentlist": "ブログコメント",
  "spblogpost": "ブログ投稿",
  "filetype_spblogpost": "ブログ投稿",
  "spblogpostlist": "ブログ投稿",
  "filetype_spblogpostlist": "ブログ投稿",
  "spdataconnectionlibrarylist": "データ接続ライブラリ",
  "filetype_spdataconnectionlibrarylist": "データ接続ライブラリ",
  "spdistributiongroup": "配布グループ",
  "filetype_spdistributiongroup": "配布グループ",
  "spdistributiongrouplist": "配布グループ",
  "filetype_spdistributiongrouplist": "配布グループ",
  "spipfslist": "InfoPathフォームサーバー",
  "filetype_spipfslist": "InfoPathフォームサーバー",
  "spkeyperformanceindicator": "主要業績評価指標",
  "filetype_spkeyperformanceindicator": "主要業績評価指標",
  "spkeyperformanceindicatorlist": "主要業績評価指標",
  "filetype_spkeyperformanceindicatorlist": "主要業績評価指標",
  "splanguagesandtranslator": "言語と翻訳者",
  "filetype_splanguagesandtranslator": "言語と翻訳者",
  "splanguagesandtranslatorlist": "言語と翻訳者",
  "filetype_splanguagesandtranslatorlist": "言語と翻訳者",
  "spmasterpagescataloglist": "マスターページギャラリー",
  "filetype_spmasterpagescataloglist": "マスターページギャラリー",
  "spnocodeworkflowlibrarylist": "コードなしのワークフローライブラリ",
  "filetype_spnocodeworkflowlibrarylist": "コードなしのワークフローライブラリ",
  "spprojecttask": "プロジェクトタスク",
  "filetype_spprojecttask": "プロジェクトタスク",
  "spprojecttasklist": "プロジェクトタスク",
  "filetype_spprojecttasklist": "プロジェクトタスク",
  "sppublishingpageslibrarylist": "ページライブラリ",
  "filetype_sppublishingpageslibrarylist": "ページライブラリ",
  "spreportdocumentlibrarylist": "レポートドキュメントライブラリ",
  "filetype_spreportdocumentlibrarylist": "レポートドキュメントライブラリ",
  "spreportlibrarylist": "レポートライブラリ",
  "filetype_spreportlibrarylist": "レポートライブラリ",
  "spslidelibrarylist": "スライドライブラリ",
  "filetype_spslidelibrarylist": "スライドライブラリ",
  "sptab": "タブ",
  "filetype_sptab": "タブ",
  "sptablist": "タブリスト",
  "filetype_sptablist": "タブリスト",
  "sptranslationmanagementlibrarylist": "翻訳管理ライブラリ",
  "filetype_sptranslationmanagementlibrarylist": "翻訳管理ライブラリ",
  "spuserinformation": "ユーザー情報",
  "filetype_spuserinformation": "ユーザー情報",
  "spuserinformationlist": "ユーザー情報リスト",
  "filetype_spuserinformationlist": "ユーザー情報リスト",
  "spwikipagelibrarylist": "Wikiページライブラリ",
  "filetype_spwikipagelibrarylist": "Wikiページライブラリ",
  "spworkflowhistory": "ワークフローの履歴",
  "filetype_spworkflowhistory": "ワークフローの履歴",
  "spworkflowhistorylist": "ワークフロー履歴リスト",
  "filetype_spworkflowhistorylist": "ワークフロー履歴リスト",
  "spworkflowprocess": "カスタムワークフロープロセス",
  "filetype_spworkflowprocess": "カスタムワークフロープロセス",
  "spworkflowprocesslist": "カスタムワークフロープロセス",
  "filetype_spworkflowprocesslist": "カスタムワークフロープロセス",
  "sppublishingimageslibrarylist": "発行イメージライブラリ",
  "filetype_sppublishingimageslibrarylist": "発行イメージライブラリ",
  "spcirculation": "回覧",
  "filetype_spcirculation": "回覧",
  "spcirculationlist": "回覧",
  "filetype_spcirculationlist": "回覧",
  "spdashboardslibrarylist": "ダッシュボードライブラリ",
  "filetype_spdashboardslibrarylist": "ダッシュボードライブラリ",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePointデータ接続ライブラリ",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePointデータ接続ライブラリ",
  "sphealthreport": "正常性レポート",
  "filetype_sphealthreport": "正常性レポート",
  "sphealthreportlist": "正常性レポート",
  "filetype_sphealthreportlist": "正常性レポート",
  "sphealthrule": "正常性ルール",
  "filetype_sphealthrule": "正常性ルール",
  "sphealthrulelist": "正常性ルール",
  "filetype_sphealthrulelist": "正常性ルール",
  "spimedictionary": "IME辞書",
  "filetype_spimedictionary": "IME辞書",
  "spimedictionarylist": "IME辞書",
  "filetype_spimedictionarylist": "IME辞書",
  "spperformancepointcontent": "PerformancePointコンテンツ",
  "filetype_spperformancepointcontent": "PerformancePointコンテンツ",
  "spperformancepointcontentlist": "PerformancePointコンテンツ",
  "filetype_spperformancepointcontentlist": "PerformancePointコンテンツ",
  "spphonecallmemo": "電話メモ",
  "filetype_spphonecallmemo": "電話メモ",
  "spphonecallmemolist": "電話メモ",
  "filetype_spphonecallmemolist": "電話メモ",
  "sprecordlibrarylist": "レコードライブラリ",
  "filetype_sprecordlibrarylist": "レコードライブラリ",
  "spresource": "リソース",
  "filetype_spresource": "リソース",
  "spresourcelist": "リソース",
  "filetype_spresourcelist": "リソース",
  "spprocessdiagramslibrarylist": "プロセスダイアグラムライブラリ",
  "filetype_spprocessdiagramslibrarylist": "プロセスダイアグラムライブラリ",
  "spsitethemeslibrarylist": "サイトテーマライブラリ",
  "filetype_spsitethemeslibrarylist": "サイトテーマライブラリ",
  "spsolutionslibrarylist": "ソリューションライブラリ",
  "filetype_spsolutionslibrarylist": "ソリューションライブラリ",
  "spwfpublibrarylist": "WFPUBライブラリ",
  "filetype_spwfpublibrarylist": "WFPUBライブラリ",
  "spwhereabout": "所在情報",
  "filetype_spwhereabout": "所在情報",
  "spwhereaboutlist": "所在情報",
  "filetype_spwhereaboutlist": "所在情報",
  "spdocumentlink": "ドキュメントにリンクする",
  "filetype_spdocumentlink": "ドキュメントにリンクする",
  "spdocumentset": "ドキュメントセット",
  "filetype_spdocumentset": "ドキュメントセット",
  "spmicrofeedpost": "マイクロフィードの投稿",
  "filetype_spmicrofeedpost": "マイクロフィードの投稿",
  "spmicrofeedlist": "マイクロフィード",
  "filetype_spmicrofeedlist": "マイクロフィード",
  "splistfolder": "リストフォルダ",
  "filetype_splistfolder": "リストフォルダ",
  "Unknown": "不明",
  "And": "および",
  "Authenticating": "{0}を認証中...",
  "Clear": "{0}をクリア",
  "CompleteQuery": "すべてのクエリ",
  "Exclude": "{0}を除外",
  "EnterTag": "タグを追加",
  "Next": "次へ",
  "Last": "最後へ",
  "Link": "リンク",
  "Or": "または",
  "Previous": "前へ",
  "QueryDidntMatchAnyDocuments": "クエリがどのドキュメントにも適合しませんでした。",
  "QueryException": "クエリにエラーがあります：{0}。",
  "Me": "ユーザー自身",
  "Remove": "削除する",
  "Search": "検索する",
  "SearchFor": "{0}を検索",
  "ShareQuery": "クエリを共有",
  "Preferences": "優先項目",
  "LinkOpeningSettings": "リンクを開く設定",
  "Reauthenticate": "{0}を再認証",
  "ResultsFilteringExpression": "結果フィルタリング表現",
  "FiltersInYourPreferences": "優先するフィルター",
  "Create": "作成する",
  "SearchIn": "{0}を検索",
  "Seconds": "{0}秒",
  "ShowingResultsOf": "結果{2}件中{0}<pl>～{1}</pl>",
  "ShowingResultsOfWithQuery": "{3} の結果 {2} 件中 {0}<pl>~{1}</pl>件を表示",
  "SwitchTo": "{0}に変更",
  "Unexclude": "{0}の除外を元に戻す",
  "ClearAllFilters": "すべてのフィルターをクリア",
  "SkipLogin": "ログインをスキップ",
  "LoginInProgress": "ログイン中、お待ちください...",
  "Login": "ログインする",
  "GetStarted": "始める",
  "More": "もっと表示",
  "NMore": "{0}件以上...",
  "Less": "少なく表示",
  "Settings": "設定",
  "Score": "スコア",
  "ScoreDescription": "スコアは発生回数ならびに一連の結果内での位置から計算されます。",
  "Occurrences": "発生",
  "OccurrencesDescription": "発生回数の高い値から順に並べ替える",
  "Label": "ラベル",
  "Of": "/",
  "LabelDescription": "フィールド値をアルファベット順に並べ替える",
  "Value": "値",
  "ValueDescription": "最初の計算フィールドの値を並べ替える",
  "AlphaAscending": "値の小さい順",
  "AlphaDescending": "値の大きい順",
  "ChiSquare": "カイ二乗",
  "Nosort": "並び替えなし",
  "NosortDescription": "値の並び替えをしないでください。値はランダムな順序で返されます。",
  "RelativeFrequency": "相対頻度",
  "RelativeFrequencyDescription": "値の相対頻度で並べ替える。相対頻度の低い値から順に表示。",
  "DateDistribution": "日付の分布",
  "Custom": "カスタム作成",
  "CustomDescription": "カスタム作成した条件で並べ替える",
  "ComputedField": "計算フィールド",
  "Ascending": "昇順",
  "Descending": "降順",
  "noResultFor": "{0}に該当する結果なし",
  "autoCorrectedQueryTo": "クエリは{0}に自動修正されました",
  "didYouMean": "もしかして：{0}",
  "SuggestedResults": "提案された結果",
  "SuggestedQueries": "提案されたクエリ",
  "MostRelevantItems": "最も関連性の高い項目：",
  "AllItems": "全項目：",
  "ShowLess": "少なく表示",
  "ShowMore": "もっと表示",
  "HideFacet": "ファセットを隠す",
  "ShowFacet": "ファセットを表示",
  "AndOthers": "およびその他{0}件",
  "Others": "その他{0}件",
  "MostRelevantPosts": "最も関連性の高い投稿：",
  "CompleteThread": "すべてのスレッド：",
  "ShowCompleteThread": "すべてのスレッドを表示",
  "ShowOnlyTopMatchingPosts": "一致した上位の投稿のみを表示",
  "MostRelevantReplies": "最も関連性の高い返信：",
  "AllConversation": "すべての会話：",
  "ShowAllConversation": "すべての会話を表示",
  "ShowAllReplies": "すべての返信を表示",
  "ShowOnlyMostRelevantReplies": "最も関連性の高い返信のみを表示",
  "Close": "閉じる",
  "Open": "開く",
  "OpenInOutlookWhenPossible": "Outlookで開く（可能な場合）",
  "AlwaysOpenInNewWindow": "常に新しいウィンドウで結果を開く",
  "Quickview": "クイックビュー",
  "NoQuickview": "このドキュメントのクイックビューはありません",
  "ErrorReport": "エラー報告",
  "OopsError": "申し訳ございません。サーバー上で問題が発生しました。",
  "ProblemPersists": "問題が解決しない場合は、管理者までご連絡ください。",
  "GoBack": "戻る",
  "Reset": "リセット",
  "Retry": "再試行",
  "MoreInfo": "詳細",
  "Username": "ユーザー名",
  "Password": "パスワード",
  "PostedBy": "投稿者名",
  "CannotConnect": "サーバーアドレスに接続できません。",
  "BadUserPass": "ユーザー名とパスワードが一致しません。",
  "PleaseEnterYourCredentials": "{0}の認証情報を入力してください。",
  "PleaseEnterYourSearchPage": "検索ページのURLを入力してください",
  "Collapse": "折り畳む",
  "Collapsable": "折り畳み可能",
  "Expand": "展開する",
  "Today": "今日",
  "Yesterday": "昨日",
  "Tomorrow": "明日",
  "Duration": "期間：{0}",
  "IndexDuration": "インデックス期間：{0}",
  "ProxyDuration": "プロキシ期間：{0}",
  "ClientDuration": "クライアント期間：{0}",
  "Unavailable": "不明",
  "Reply": "返信",
  "ReplyAll": "全員に返信",
  "Forward": "転送",
  "From": "差出人",
  "Caption": "表題",
  "Expression": "表現",
  "Tab": "タブ",
  "Tabs": "タブ",
  "EnterExpressionName": "表現名を入力",
  "EnterExpressionToFilterWith": "結果をフィルターする表現を入力",
  "SelectTab": "タブを選択",
  "SelectAll": "すべてを選択",
  "PageUrl": "ページのURLを検索",
  "ErrorSavingToDevice": "デバイスへの情報保存中にエラー発生",
  "ErrorReadingFromDevice": "デバイスから情報読み込み中にエラー発生",
  "AppIntro": "Coveoに関するご質問にお答えし、お客様に合ったCoveoソリューションの選択をお手伝いする製品スペシャリストと話す。または、実践デモをお試しください！",
  "TryDemo": "デモを試す",
  "ContactUs": "お問い合わせ",
  "NewToCoveo": "Coveoのご利用は初めてですか？",
  "LetUsHelpGetStarted": "始めるお手伝いをいたします",
  "LikesThis": "{0}はこれがお気に入りです。",
  "CannotConnectSearchPage": "検索ページに接続できません",
  "AreYouSureDeleteFilter": "本当に、フィルタ{0}と表現{1}を削除しますか",
  "OnlineHelp": "オンラインヘルプ",
  "Done": "完了",
  "SaveFacetState": "このファセット状態を保存",
  "ClearFacetState": "ファセット状態をクリア",
  "DisplayingTheOnlyMessage": "本会話中のメッセージのみを表示",
  "NoNetworkConnection": "ネットワーク接続なし",
  "UnknownConnection": "不明の接続",
  "EthernetConnection": "イーサネット接続",
  "WiFi": "Wi-Fi接続",
  "CELL": "携帯電話接続",
  "CELL_2G": "2G携帯電話接続",
  "CELL_3G": "3G携帯電話接続",
  "CELL_4G": "4G携帯電話接続",
  "Relevance": "関連性",
  "Date": "日付",
  "Amount": "量",
  "QueryExceptionNoException": "例外なし",
  "QueryExceptionInvalidSyntax": "無効の構文",
  "QueryExceptionInvalidCustomField": "無効のカスタム作成フィールド",
  "QueryExceptionInvalidDate": "無効の日付",
  "QueryExceptionInvalidExactPhrase": "無効の完全一致",
  "QueryExceptionInvalidDateOp": "無効の日付演算子",
  "QueryExceptionInvalidNear": "無効のNEAR演算子",
  "QueryExceptionInvalidWeightedNear": "無効の重み付けNEAR",
  "QueryExceptionInvalidTerm": "無効の語句",
  "QueryExceptionTooManyTerms": "語句が多すぎます",
  "QueryExceptionWildcardTooGeneral": "ワイルドカードが一般的すぎます",
  "QueryExceptionInvalidSortField": "無効の並び替えフィールド",
  "QueryExceptionInvalidSmallStringOp": "無効の小文字列演算子",
  "QueryExceptionRequestedResultsMax": "要求した結果最大数",
  "QueryExceptionAggregatedMirrorDead": "リモートインデックスはオフラインです",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "リモートインデックスのクエリがタイムアウトしました",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "リモートインデックス無効の形成数字です",
  "QueryExceptionAggregatedMirrorCannotConnect": "リモートインデックスに接続できません",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "主要ワイルドカード不足です",
  "QueryExceptionSecurityInverterNotFound": "セキュリティインバーターが見つかりません",
  "QueryExceptionSecurityInverterAccessDenied": "セキュリティインバーターのアクセスが拒否されました",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "リモートインデックスはなりすまし利用できません",
  "QueryExceptionUnexpected": "想定外",
  "QueryExceptionAccessDenied": "アクセスが拒否されました",
  "QueryExceptionSuperUserTokenInvalid": "スーパーユーザートークンが無効です",
  "QueryExceptionSuperUserTokenExpired": "スーパーユーザートークンが失効しています",
  "QueryExceptionLicenseQueriesExpired": "クエリライセンスが失効しています",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "スーパーユーザートークンのライセンスがサポートされていません",
  "QueryExceptionInvalidSession": "無効のセッション",
  "QueryExceptionInvalidDocument": "無効のドキュメント",
  "QueryExceptionSearchDisabled": "検索が無効になっています",
  "FileType": "ファイルの種類",
  "ShowAttachment": "添付を表示",
  "OnFeed": "{0}のフィードに",
  "Author": "作成者",
  "NoTitle": "表題なし",
  "CurrentSelections": "現在の選択項目",
  "AllContent": "すべての内容",
  "CancelLastAction": "最後の動作を取り消す",
  "SearchTips": "検索ヒント",
  "CheckSpelling": "キーワードのスペルを確認してください。",
  "TryUsingFewerKeywords": "より少ない、異なる、または一般的なキーワードを使用してみてください。",
  "SelectFewerFilters": "選択するフィルタ数を減らして検索の幅を広げてください。",
  "Document": "ドキュメント",
  "Time": "時間",
  "StartDate": "開始日",
  "StartTime": "開始時刻",
  "DurationTitle": "期間",
  "UserQuery": "ユーザークエリ",
  "ShowUserActions": "ユーザーアクションを表示",
  "NoData": "データがありません",
  "EventType": "イベントタイプ",
  "GoToFullSearch": "完全検索",
  "GoToEdition": "パネルをカスタマイズする",
  "RemoveContext": "コンテキストの削除",
  "BoxAttachToCase": "ケースに添付",
  "AttachToCase": "ケースに添付",
  "Attach": "添付",
  "Attached": "添付済み",
  "Detach": "添付解除",
  "Details": "詳細",
  "AdditionalFilters": "追加のフィルタ",
  "SelectNonContextualSearch": "現在の記録から",
  "CopyPasteToSupport": "このメッセージをコピー＆ペーストして、Coveoサポートチームに詳細について問い合わせます。",
  "FollowQueryDescription": "このクエリの検索結果に変更があった場合にアラートを送信してください。",
  "SearchAlerts_Panel": "アラートの管理",
  "SearchAlerts_PanelDescription": "検索アラートの表示と管理を行います。",
  "SearchAlerts_PanelNoSearchAlerts": "サブスクリプションがありません。",
  "SearchAlerts_Fail": "検索アラートサービスは現在利用できません。",
  "SearchAlerts_Type": "タイプ",
  "SearchAlerts_Content": "内容",
  "SearchAlerts_Actions": "アクション",
  "EmptyQuery": "<空>",
  "SearchAlerts_Type_followQuery": "クエリ",
  "SearchAlerts_Type_followDocument": "項目",
  "SearchAlerts_unFollowing": "フォローの停止",
  "SearchAlerts_follow": "フォロー",
  "SearchAlerts_followed": "フォロー済み",
  "SearchAlerts_followQuery": "クエリのフォロー",
  "Subscription_StopFollowingQuery": "クエリのフォローを停止",
  "SearchAlerts_Frequency": "日時",
  "SubscriptionsManageSubscriptions": "アラートの管理",
  "SubscriptionsMessageFollowQuery": "クエリ<b>{0}</b>が新規または更新済み項目を返した時にアラートを受信します。",
  "SubscriptionsMessageFollow": "項目<b>{0}</b>への変更についてのアラートを受信します。",
  "Expiration": "有効期限",
  "Monthly": "毎月",
  "Daily": "毎日",
  "Monday": "月曜日",
  "Tuesday": "火曜日",
  "Wednesday": "水曜日",
  "Thursday": "木曜日",
  "Friday": "金曜日",
  "Saturday": "土曜日",
  "Sunday": "日曜日",
  "NextDay": "来週の{0}",
  "LastDay": "先週の{0}",
  "StartTypingCaseForSuggestions": "ソリューションを表示するために問題について説明してください",
  "ExportToExcel": "Excelにエクスポート",
  "ExportToExcelDescription": "検索結果をExcelにエキスポート",
  "CaseCreationNoResults": "推奨ソリューションが見つかりませんでした",
  "SortBy": "並べ替え順",
  "BoxCreateArticle": "記事を作成する",
  "Facets": "ファセット",
  "AdvancedSearch": "高度検索",
  "Keywords": "キーワード",
  "AllTheseWords": "すべての言葉",
  "ExactPhrase": "完全に一致するフレーズ",
  "AnyOfTheseWords": "いずれかの言葉",
  "NoneOfTheseWords": "いずれの言葉も含まない",
  "Anytime": "随時",
  "InTheLast": "過去",
  "Days": "日",
  "Months": "月",
  "Month": "月",
  "Year": "年",
  "Between": "期間",
  "Language": "言語",
  "Size": "サイズ",
  "AtLeast": "最小",
  "AtMost": "最大",
  "Contains": "次を含む：",
  "DoesNotContain": "次の値を含まない",
  "Matches": "一致",
  "Bytes": "バイト",
  "card": "カード",
  "table": "表",
  "ResultLinks": "結果のリンク",
  "EnableQuerySyntax": "クエリ構文を有効にする",
  "On": "オン",
  "Off": "オフ",
  "Automatic": "自動",
  "ResultsPerPage": "ページごとの結果",
  "PreviousMonth": "前月",
  "NextMonth": "来月",
  "Title": "表題",
}
  var locales = String["locales"] || (String["locales"] = {});
  locales["ja"] = merge(locales["ja"], dict);
  String["toLocaleString"].call(this, { "ja": dict });
  String["locale"] = "ja";
  String["defaultLocale"] = "en";
  Globalize.culture("ja")})();
if(!window.Coveo){window.Coveo = {};}
Coveo.setLanguageAfterPageLoaded = function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}

var dict = {
  "box user": "ユーザー",
  "filetype_box user": "ユーザー",
  "html": "HTMLファイル",
  "filetype_html": "HTMLファイル",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "ウェブページ",
  "filetype_webscraperwebpage": "ウェブページ",
  "image": "画像",
  "filetype_image": "画像",
  "folder": "フォルダ",
  "filetype_folder": "フォルダ",
  "txt": "テキスト",
  "filetype_txt": "テキスト",
  "zip": "Zipファイル",
  "filetype_zip": "Zipファイル",
  "olefile": "OLEファイル",
  "filetype_olefile": "OLEファイル",
  "gmailmessage": "Gmailメッセージ",
  "filetype_gmailmessage": "Gmailメッセージ",
  "pdf": "PDFファイル",
  "filetype_pdf": "PDFファイル",
  "swf": "Flashファイル",
  "filetype_swf": "Flashファイル",
  "xml": "XMLファイル",
  "filetype_xml": "XMLファイル",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "RSSフィード",
  "filetype_rssitem": "RSSフィード",
  "doc": "ドキュメント",
  "filetype_doc": "ドキュメント",
  "docx": "Microsoft Wordドキュメント",
  "filetype_docx": "Microsoft Wordドキュメント",
  "xls": "スプレッドシートドキュメント",
  "filetype_xls": "スプレッドシートドキュメント",
  "ppt": "プレゼンテーションドキュメント",
  "filetype_ppt": "プレゼンテーションドキュメント",
  "video": "ビデオ",
  "filetype_video": "ビデオ",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "Open Textドキュメント",
  "filetype_odt": "Open Textドキュメント",
  "lithiummessage": "Lithiumメッセージ",
  "filetype_lithiummessage": "Lithiumメッセージ",
  "lithiumthread": "Lithiumスレッド",
  "filetype_lithiumthread": "Lithiumスレッド",
  "lithiumboard": "Lithiumボード",
  "filetype_lithiumboard": "Lithiumボード",
  "lithiumcategory": "Lithiumカテゴリ",
  "filetype_lithiumcategory": "Lithiumカテゴリ",
  "lithiumcommunity": "Lithiumコミュニティ",
  "filetype_lithiumcommunity": "Lithiumコミュニティ",
  "people": "ユーザー",
  "objecttype_people": "ユーザー",
  "message": "メッセージ",
  "objecttype_message": "メッセージ",
  "feed": "RSSフィード",
  "objecttype_feed": "RSSフィード",
  "thread": "スレッド",
  "objecttype_thread": "スレッド",
  "file": "ファイル",
  "objecttype_file": "ファイル",
  "board": "ボード",
  "objecttype_board": "ボード",
  "category": "カテゴリ",
  "objecttype_category": "カテゴリ",
  "account": "アカウント",
  "objecttype_account": "アカウント",
  "annotation": "注",
  "objecttype_annotation": "注",
  "campaign": "キャンペーン",
  "objecttype_campaign": "キャンペーン",
  "case": "ケース",
  "objecttype_case": "ケース",
  "contact": "連絡先",
  "objecttype_contact": "連絡先",
  "contract": "契約",
  "objecttype_contract": "契約",
  "event": "イベント",
  "objecttype_event": "イベント",
  "email": "電子メール",
  "objecttype_email": "電子メール",
  "goal": "目標",
  "objecttype_goal": "目標",
  "objecttype_incident": "ケース",
  "invoice": "請求書",
  "objecttype_invoice": "請求書",
  "lead": "リード",
  "objecttype_lead": "リード",
  "list": "リスト",
  "objecttype_list": "マーケティングリスト",
  "solution": "ソリューション",
  "objecttype_solution": "ソリューション",
  "task": "タスク",
  "objecttype_task": "タスク",
  "user": "ユーザー",
  "objecttype_user": "ユーザー",
  "attachment": "添付",
  "objecttype_attachment": "添付",
  "casecomment": "ケースコメント",
  "objecttype_casecomment": "ケースコメント",
  "opportunity": "提案",
  "objecttype_opportunity": "提案",
  "opportunityproduct": "提案製品",
  "objecttype_opportunityproduct": "提案製品",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "注",
  "objecttype_note": "注",
  "product": "製品",
  "objecttype_product": "製品",
  "partner": "パートナー",
  "objecttype_partner": "パートナー",
  "queueitem": "キューアイテム",
  "objecttype_queueitem": "キューアイテム",
  "quote": "見積もり",
  "objecttype_quote": "見積もり",
  "salesliterature": "営業資料",
  "objecttype_salesliterature": "営業資料",
  "salesorder": "販売注文",
  "objecttype_salesorder": "販売注文",
  "service": "サービス",
  "objecttype_service": "サービス",
  "socialprofile": "ソーシャルプロファイル",
  "objecttype_socialprofile": "ソーシャルプロファイル",
  "kbdocumentation": "文書",
  "objecttype_kbdocumentation": "文書",
  "kbtechnicalarticle": "文書",
  "objecttype_kbtechnicalarticle": "文書",
  "kbsolution": "ソリューション",
  "objecttype_kbsolution": "ソリューション",
  "kbknowledgearticle": "ナレッジ記事",
  "objecttype_kbknowledgearticle": "ナレッジ記事",
  "kbattachment": "添付",
  "objecttype_kbattachment": "添付",
  "kbarticle": "記事",
  "objecttype_kbarticle": "記事",
  "kbarticlecomment": "記事のコメント",
  "objecttype_kbarticlecomment": "記事のコメント",
  "knowledgearticle": "ナレッジ記事",
  "objecttype_knowledgearticle": "ナレッジ記事",
  "topic": "トピック",
  "objecttype_topic": "トピック",
  "dashboard": "ダッシュボード",
  "objecttype_dashboard": "ダッシュボード",
  "contentversion": "ドキュメント",
  "objecttype_contentversion": "ドキュメント",
  "collaborationgroup": "コラボレーショングループ",
  "objecttype_collaborationgroup": "コラボレーショングループ",
  "spportal": "ポータル",
  "filetype_spportal": "ポータル",
  "spsite": "サイト",
  "filetype_spsite": "サイト",
  "spuserprofile": "SharePointユーザー",
  "filetype_spuserprofile": "SharePointユーザー",
  "sparea": "エリア",
  "filetype_sparea": "エリア",
  "spannouncement": "通知",
  "filetype_spannouncement": "通知",
  "spannouncementlist": "通知",
  "filetype_spannouncementlist": "通知",
  "spcontact": "連絡先",
  "filetype_spcontact": "連絡先",
  "spcontactlist": "連絡先",
  "filetype_spcontactlist": "連絡先",
  "spcustomlist": "カスタムリスト",
  "filetype_spcustomlist": "カスタムリスト",
  "spdiscussionboard": "ディスカッションボード",
  "filetype_spdiscussionboard": "ディスカッションボード",
  "spdiscussionboardlist": "ディスカッションボード",
  "filetype_spdiscussionboardlist": "ディスカッションボード",
  "spdocumentlibrarylist": "ドキュメントライブラリ",
  "filetype_spdocumentlibrarylist": "ドキュメントライブラリ",
  "spevent": "イベント",
  "filetype_spevent": "イベント",
  "speventlist": "イベント",
  "filetype_speventlist": "イベント",
  "spformlibrarylist": "ライブラリから",
  "filetype_spformlibrarylist": "ライブラリから",
  "spissue": "問題",
  "filetype_spissue": "問題",
  "spissuelist": "問題",
  "filetype_spissuelist": "問題",
  "splink": "リンク",
  "filetype_splink": "リンク",
  "splinklist": "リンク",
  "filetype_splinklist": "リンク",
  "sppicturelibrarylist": "画像ライブラリ",
  "filetype_sppicturelibrarylist": "画像ライブラリ",
  "spsurvey": "調査",
  "filetype_spsurvey": "調査",
  "spsurveylist": "調査",
  "filetype_spsurveylist": "調査",
  "sptask": "タスク",
  "filetype_sptask": "タスク",
  "sptasklist": "タスク",
  "filetype_sptasklist": "タスク",
  "spagenda": "議題",
  "filetype_spagenda": "議題",
  "spagendalist": "議題",
  "filetype_spagendalist": "議題",
  "spattendee": "出席者",
  "filetype_spattendee": "出席者",
  "spattendeelist": "出席者",
  "filetype_spattendeelist": "出席者",
  "spcustomgridlist": "カスタムグリッド",
  "filetype_spcustomgridlist": "カスタムグリッド",
  "spdecision": "決定",
  "filetype_spdecision": "決定",
  "spdecisionlist": "決定",
  "filetype_spdecisionlist": "決定",
  "spobjective": "目的",
  "filetype_spobjective": "目的",
  "spobjectivelist": "目的",
  "filetype_spobjectivelist": "目的",
  "sptextbox": "テキストボックス",
  "filetype_sptextbox": "テキストボックス",
  "sptextboxlist": "テキストボックスリスト",
  "filetype_sptextboxlist": "テキストボックスリスト",
  "spthingstobring": "持参物",
  "filetype_spthingstobring": "持参物",
  "spthingstobringlist": "持参物",
  "filetype_spthingstobringlist": "持参物",
  "sparealisting": "エリアの一覧",
  "filetype_sparealisting": "エリアの一覧",
  "spmeetingserie": "関連する会議",
  "filetype_spmeetingserie": "関連する会議",
  "spmeetingserielist": "関連する会議のリスト",
  "filetype_spmeetingserielist": "関連する会議のリスト",
  "spsitedirectory": "サイトディレクトリ項目",
  "filetype_spsitedirectory": "サイトディレクトリ項目",
  "spsitedirectorylist": "サイトディレクトリ",
  "filetype_spsitedirectorylist": "サイトディレクトリ",
  "spdatasource": "データソース",
  "filetype_spdatasource": "データソース",
  "spdatasourcelist": "データソースリスト",
  "filetype_spdatasourcelist": "データソースリスト",
  "splisttemplatecataloglist": "リストテンプレートギャラリー",
  "filetype_splisttemplatecataloglist": "リストテンプレートギャラリー",
  "spwebpartcataloglist": "Webパーツギャラリー",
  "filetype_spwebpartcataloglist": "Webパーツギャラリー",
  "spwebtemplatecataloglist": "サイトテンプレートギャラリー",
  "filetype_spwebtemplatecataloglist": "サイトテンプレートギャラリー",
  "spworkspacepagelist": "ワークスペースページ",
  "filetype_spworkspacepagelist": "ワークスペースページ",
  "spunknownlist": "カスタムリスト",
  "filetype_spunknownlist": "カスタムリスト",
  "spadministratortask": "管理者タスク",
  "filetype_spadministratortask": "管理者タスク",
  "spadministratortasklist": "管理者タスク",
  "filetype_spadministratortasklist": "管理者タスク",
  "spareadocumentlibrarylist": "エリアドキュメントライブラリ",
  "filetype_spareadocumentlibrarylist": "エリアドキュメントライブラリ",
  "spblogcategory": "ブログカテゴリ",
  "filetype_spblogcategory": "ブログカテゴリ",
  "spblogcategorylist": "ブログカテゴリ",
  "filetype_spblogcategorylist": "ブログカテゴリ",
  "spblogcomment": "ブログコメント",
  "filetype_spblogcomment": "ブログコメント",
  "spblogcommentlist": "ブログコメント",
  "filetype_spblogcommentlist": "ブログコメント",
  "spblogpost": "ブログ投稿",
  "filetype_spblogpost": "ブログ投稿",
  "spblogpostlist": "ブログ投稿",
  "filetype_spblogpostlist": "ブログ投稿",
  "spdataconnectionlibrarylist": "データ接続ライブラリ",
  "filetype_spdataconnectionlibrarylist": "データ接続ライブラリ",
  "spdistributiongroup": "配布グループ",
  "filetype_spdistributiongroup": "配布グループ",
  "spdistributiongrouplist": "配布グループ",
  "filetype_spdistributiongrouplist": "配布グループ",
  "spipfslist": "InfoPathフォームサーバー",
  "filetype_spipfslist": "InfoPathフォームサーバー",
  "spkeyperformanceindicator": "主要業績評価指標",
  "filetype_spkeyperformanceindicator": "主要業績評価指標",
  "spkeyperformanceindicatorlist": "主要業績評価指標",
  "filetype_spkeyperformanceindicatorlist": "主要業績評価指標",
  "splanguagesandtranslator": "言語と翻訳者",
  "filetype_splanguagesandtranslator": "言語と翻訳者",
  "splanguagesandtranslatorlist": "言語と翻訳者",
  "filetype_splanguagesandtranslatorlist": "言語と翻訳者",
  "spmasterpagescataloglist": "マスターページギャラリー",
  "filetype_spmasterpagescataloglist": "マスターページギャラリー",
  "spnocodeworkflowlibrarylist": "コードなしのワークフローライブラリ",
  "filetype_spnocodeworkflowlibrarylist": "コードなしのワークフローライブラリ",
  "spprojecttask": "プロジェクトタスク",
  "filetype_spprojecttask": "プロジェクトタスク",
  "spprojecttasklist": "プロジェクトタスク",
  "filetype_spprojecttasklist": "プロジェクトタスク",
  "sppublishingpageslibrarylist": "ページライブラリ",
  "filetype_sppublishingpageslibrarylist": "ページライブラリ",
  "spreportdocumentlibrarylist": "レポートドキュメントライブラリ",
  "filetype_spreportdocumentlibrarylist": "レポートドキュメントライブラリ",
  "spreportlibrarylist": "レポートライブラリ",
  "filetype_spreportlibrarylist": "レポートライブラリ",
  "spslidelibrarylist": "スライドライブラリ",
  "filetype_spslidelibrarylist": "スライドライブラリ",
  "sptab": "タブ",
  "filetype_sptab": "タブ",
  "sptablist": "タブリスト",
  "filetype_sptablist": "タブリスト",
  "sptranslationmanagementlibrarylist": "翻訳管理ライブラリ",
  "filetype_sptranslationmanagementlibrarylist": "翻訳管理ライブラリ",
  "spuserinformation": "ユーザー情報",
  "filetype_spuserinformation": "ユーザー情報",
  "spuserinformationlist": "ユーザー情報リスト",
  "filetype_spuserinformationlist": "ユーザー情報リスト",
  "spwikipagelibrarylist": "Wikiページライブラリ",
  "filetype_spwikipagelibrarylist": "Wikiページライブラリ",
  "spworkflowhistory": "ワークフローの履歴",
  "filetype_spworkflowhistory": "ワークフローの履歴",
  "spworkflowhistorylist": "ワークフロー履歴リスト",
  "filetype_spworkflowhistorylist": "ワークフロー履歴リスト",
  "spworkflowprocess": "カスタムワークフロープロセス",
  "filetype_spworkflowprocess": "カスタムワークフロープロセス",
  "spworkflowprocesslist": "カスタムワークフロープロセス",
  "filetype_spworkflowprocesslist": "カスタムワークフロープロセス",
  "sppublishingimageslibrarylist": "発行イメージライブラリ",
  "filetype_sppublishingimageslibrarylist": "発行イメージライブラリ",
  "spcirculation": "回覧",
  "filetype_spcirculation": "回覧",
  "spcirculationlist": "回覧",
  "filetype_spcirculationlist": "回覧",
  "spdashboardslibrarylist": "ダッシュボードライブラリ",
  "filetype_spdashboardslibrarylist": "ダッシュボードライブラリ",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePointデータ接続ライブラリ",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePointデータ接続ライブラリ",
  "sphealthreport": "正常性レポート",
  "filetype_sphealthreport": "正常性レポート",
  "sphealthreportlist": "正常性レポート",
  "filetype_sphealthreportlist": "正常性レポート",
  "sphealthrule": "正常性ルール",
  "filetype_sphealthrule": "正常性ルール",
  "sphealthrulelist": "正常性ルール",
  "filetype_sphealthrulelist": "正常性ルール",
  "spimedictionary": "IME辞書",
  "filetype_spimedictionary": "IME辞書",
  "spimedictionarylist": "IME辞書",
  "filetype_spimedictionarylist": "IME辞書",
  "spperformancepointcontent": "PerformancePointコンテンツ",
  "filetype_spperformancepointcontent": "PerformancePointコンテンツ",
  "spperformancepointcontentlist": "PerformancePointコンテンツ",
  "filetype_spperformancepointcontentlist": "PerformancePointコンテンツ",
  "spphonecallmemo": "電話メモ",
  "filetype_spphonecallmemo": "電話メモ",
  "spphonecallmemolist": "電話メモ",
  "filetype_spphonecallmemolist": "電話メモ",
  "sprecordlibrarylist": "レコードライブラリ",
  "filetype_sprecordlibrarylist": "レコードライブラリ",
  "spresource": "リソース",
  "filetype_spresource": "リソース",
  "spresourcelist": "リソース",
  "filetype_spresourcelist": "リソース",
  "spprocessdiagramslibrarylist": "プロセスダイアグラムライブラリ",
  "filetype_spprocessdiagramslibrarylist": "プロセスダイアグラムライブラリ",
  "spsitethemeslibrarylist": "サイトテーマライブラリ",
  "filetype_spsitethemeslibrarylist": "サイトテーマライブラリ",
  "spsolutionslibrarylist": "ソリューションライブラリ",
  "filetype_spsolutionslibrarylist": "ソリューションライブラリ",
  "spwfpublibrarylist": "WFPUBライブラリ",
  "filetype_spwfpublibrarylist": "WFPUBライブラリ",
  "spwhereabout": "所在情報",
  "filetype_spwhereabout": "所在情報",
  "spwhereaboutlist": "所在情報",
  "filetype_spwhereaboutlist": "所在情報",
  "spdocumentlink": "ドキュメントにリンクする",
  "filetype_spdocumentlink": "ドキュメントにリンクする",
  "spdocumentset": "ドキュメントセット",
  "filetype_spdocumentset": "ドキュメントセット",
  "spmicrofeedpost": "マイクロフィードの投稿",
  "filetype_spmicrofeedpost": "マイクロフィードの投稿",
  "spmicrofeedlist": "マイクロフィード",
  "filetype_spmicrofeedlist": "マイクロフィード",
  "splistfolder": "リストフォルダ",
  "filetype_splistfolder": "リストフォルダ",
  "Unknown": "不明",
  "And": "および",
  "Authenticating": "{0}を認証中...",
  "Clear": "{0}をクリア",
  "CompleteQuery": "すべてのクエリ",
  "Exclude": "{0}を除外",
  "EnterTag": "タグを追加",
  "Next": "次へ",
  "Last": "最後へ",
  "Link": "リンク",
  "Or": "または",
  "Previous": "前へ",
  "QueryDidntMatchAnyDocuments": "クエリがどのドキュメントにも適合しませんでした。",
  "QueryException": "クエリにエラーがあります：{0}。",
  "Me": "ユーザー自身",
  "Remove": "削除する",
  "Search": "検索する",
  "SearchFor": "{0}を検索",
  "ShareQuery": "クエリを共有",
  "Preferences": "優先項目",
  "LinkOpeningSettings": "リンクを開く設定",
  "Reauthenticate": "{0}を再認証",
  "ResultsFilteringExpression": "結果フィルタリング表現",
  "FiltersInYourPreferences": "優先するフィルター",
  "Create": "作成する",
  "SearchIn": "{0}を検索",
  "Seconds": "{0}秒",
  "ShowingResultsOf": "結果{2}件中{0}<pl>～{1}</pl>",
  "ShowingResultsOfWithQuery": "{3} の結果 {2} 件中 {0}<pl>~{1}</pl>件を表示",
  "SwitchTo": "{0}に変更",
  "Unexclude": "{0}の除外を元に戻す",
  "ClearAllFilters": "すべてのフィルターをクリア",
  "SkipLogin": "ログインをスキップ",
  "LoginInProgress": "ログイン中、お待ちください...",
  "Login": "ログインする",
  "GetStarted": "始める",
  "More": "もっと表示",
  "NMore": "{0}件以上...",
  "Less": "少なく表示",
  "Settings": "設定",
  "Score": "スコア",
  "ScoreDescription": "スコアは発生回数ならびに一連の結果内での位置から計算されます。",
  "Occurrences": "発生",
  "OccurrencesDescription": "発生回数の高い値から順に並べ替える",
  "Label": "ラベル",
  "Of": "/",
  "LabelDescription": "フィールド値をアルファベット順に並べ替える",
  "Value": "値",
  "ValueDescription": "最初の計算フィールドの値を並べ替える",
  "AlphaAscending": "値の小さい順",
  "AlphaDescending": "値の大きい順",
  "ChiSquare": "カイ二乗",
  "Nosort": "並び替えなし",
  "NosortDescription": "値の並び替えをしないでください。値はランダムな順序で返されます。",
  "RelativeFrequency": "相対頻度",
  "RelativeFrequencyDescription": "値の相対頻度で並べ替える。相対頻度の低い値から順に表示。",
  "DateDistribution": "日付の分布",
  "Custom": "カスタム作成",
  "CustomDescription": "カスタム作成した条件で並べ替える",
  "ComputedField": "計算フィールド",
  "Ascending": "昇順",
  "Descending": "降順",
  "noResultFor": "{0}に該当する結果なし",
  "autoCorrectedQueryTo": "クエリは{0}に自動修正されました",
  "didYouMean": "もしかして：{0}",
  "SuggestedResults": "提案された結果",
  "SuggestedQueries": "提案されたクエリ",
  "MostRelevantItems": "最も関連性の高い項目：",
  "AllItems": "全項目：",
  "ShowLess": "少なく表示",
  "ShowMore": "もっと表示",
  "HideFacet": "ファセットを隠す",
  "ShowFacet": "ファセットを表示",
  "AndOthers": "およびその他{0}件",
  "Others": "その他{0}件",
  "MostRelevantPosts": "最も関連性の高い投稿：",
  "CompleteThread": "すべてのスレッド：",
  "ShowCompleteThread": "すべてのスレッドを表示",
  "ShowOnlyTopMatchingPosts": "一致した上位の投稿のみを表示",
  "MostRelevantReplies": "最も関連性の高い返信：",
  "AllConversation": "すべての会話：",
  "ShowAllConversation": "すべての会話を表示",
  "ShowAllReplies": "すべての返信を表示",
  "ShowOnlyMostRelevantReplies": "最も関連性の高い返信のみを表示",
  "Close": "閉じる",
  "Open": "開く",
  "OpenInOutlookWhenPossible": "Outlookで開く（可能な場合）",
  "AlwaysOpenInNewWindow": "常に新しいウィンドウで結果を開く",
  "Quickview": "クイックビュー",
  "NoQuickview": "このドキュメントのクイックビューはありません",
  "ErrorReport": "エラー報告",
  "OopsError": "申し訳ございません。サーバー上で問題が発生しました。",
  "ProblemPersists": "問題が解決しない場合は、管理者までご連絡ください。",
  "GoBack": "戻る",
  "Reset": "リセット",
  "Retry": "再試行",
  "MoreInfo": "詳細",
  "Username": "ユーザー名",
  "Password": "パスワード",
  "PostedBy": "投稿者名",
  "CannotConnect": "サーバーアドレスに接続できません。",
  "BadUserPass": "ユーザー名とパスワードが一致しません。",
  "PleaseEnterYourCredentials": "{0}の認証情報を入力してください。",
  "PleaseEnterYourSearchPage": "検索ページのURLを入力してください",
  "Collapse": "折り畳む",
  "Collapsable": "折り畳み可能",
  "Expand": "展開する",
  "Today": "今日",
  "Yesterday": "昨日",
  "Tomorrow": "明日",
  "Duration": "期間：{0}",
  "IndexDuration": "インデックス期間：{0}",
  "ProxyDuration": "プロキシ期間：{0}",
  "ClientDuration": "クライアント期間：{0}",
  "Unavailable": "不明",
  "Reply": "返信",
  "ReplyAll": "全員に返信",
  "Forward": "転送",
  "From": "差出人",
  "Caption": "表題",
  "Expression": "表現",
  "Tab": "タブ",
  "Tabs": "タブ",
  "EnterExpressionName": "表現名を入力",
  "EnterExpressionToFilterWith": "結果をフィルターする表現を入力",
  "SelectTab": "タブを選択",
  "SelectAll": "すべてを選択",
  "PageUrl": "ページのURLを検索",
  "ErrorSavingToDevice": "デバイスへの情報保存中にエラー発生",
  "ErrorReadingFromDevice": "デバイスから情報読み込み中にエラー発生",
  "AppIntro": "Coveoに関するご質問にお答えし、お客様に合ったCoveoソリューションの選択をお手伝いする製品スペシャリストと話す。または、実践デモをお試しください！",
  "TryDemo": "デモを試す",
  "ContactUs": "お問い合わせ",
  "NewToCoveo": "Coveoのご利用は初めてですか？",
  "LetUsHelpGetStarted": "始めるお手伝いをいたします",
  "LikesThis": "{0}はこれがお気に入りです。",
  "CannotConnectSearchPage": "検索ページに接続できません",
  "AreYouSureDeleteFilter": "本当に、フィルタ{0}と表現{1}を削除しますか",
  "OnlineHelp": "オンラインヘルプ",
  "Done": "完了",
  "SaveFacetState": "このファセット状態を保存",
  "ClearFacetState": "ファセット状態をクリア",
  "DisplayingTheOnlyMessage": "本会話中のメッセージのみを表示",
  "NoNetworkConnection": "ネットワーク接続なし",
  "UnknownConnection": "不明の接続",
  "EthernetConnection": "イーサネット接続",
  "WiFi": "Wi-Fi接続",
  "CELL": "携帯電話接続",
  "CELL_2G": "2G携帯電話接続",
  "CELL_3G": "3G携帯電話接続",
  "CELL_4G": "4G携帯電話接続",
  "Relevance": "関連性",
  "Date": "日付",
  "Amount": "量",
  "QueryExceptionNoException": "例外なし",
  "QueryExceptionInvalidSyntax": "無効の構文",
  "QueryExceptionInvalidCustomField": "無効のカスタム作成フィールド",
  "QueryExceptionInvalidDate": "無効の日付",
  "QueryExceptionInvalidExactPhrase": "無効の完全一致",
  "QueryExceptionInvalidDateOp": "無効の日付演算子",
  "QueryExceptionInvalidNear": "無効のNEAR演算子",
  "QueryExceptionInvalidWeightedNear": "無効の重み付けNEAR",
  "QueryExceptionInvalidTerm": "無効の語句",
  "QueryExceptionTooManyTerms": "語句が多すぎます",
  "QueryExceptionWildcardTooGeneral": "ワイルドカードが一般的すぎます",
  "QueryExceptionInvalidSortField": "無効の並び替えフィールド",
  "QueryExceptionInvalidSmallStringOp": "無効の小文字列演算子",
  "QueryExceptionRequestedResultsMax": "要求した結果最大数",
  "QueryExceptionAggregatedMirrorDead": "リモートインデックスはオフラインです",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "リモートインデックスのクエリがタイムアウトしました",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "リモートインデックス無効の形成数字です",
  "QueryExceptionAggregatedMirrorCannotConnect": "リモートインデックスに接続できません",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "主要ワイルドカード不足です",
  "QueryExceptionSecurityInverterNotFound": "セキュリティインバーターが見つかりません",
  "QueryExceptionSecurityInverterAccessDenied": "セキュリティインバーターのアクセスが拒否されました",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "リモートインデックスはなりすまし利用できません",
  "QueryExceptionUnexpected": "想定外",
  "QueryExceptionAccessDenied": "アクセスが拒否されました",
  "QueryExceptionSuperUserTokenInvalid": "スーパーユーザートークンが無効です",
  "QueryExceptionSuperUserTokenExpired": "スーパーユーザートークンが失効しています",
  "QueryExceptionLicenseQueriesExpired": "クエリライセンスが失効しています",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "スーパーユーザートークンのライセンスがサポートされていません",
  "QueryExceptionInvalidSession": "無効のセッション",
  "QueryExceptionInvalidDocument": "無効のドキュメント",
  "QueryExceptionSearchDisabled": "検索が無効になっています",
  "FileType": "ファイルの種類",
  "ShowAttachment": "添付を表示",
  "OnFeed": "{0}のフィードに",
  "Author": "作成者",
  "NoTitle": "表題なし",
  "CurrentSelections": "現在の選択項目",
  "AllContent": "すべての内容",
  "CancelLastAction": "最後の動作を取り消す",
  "SearchTips": "検索ヒント",
  "CheckSpelling": "キーワードのスペルを確認してください。",
  "TryUsingFewerKeywords": "より少ない、異なる、または一般的なキーワードを使用してみてください。",
  "SelectFewerFilters": "選択するフィルタ数を減らして検索の幅を広げてください。",
  "Document": "ドキュメント",
  "Time": "時間",
  "StartDate": "開始日",
  "StartTime": "開始時刻",
  "DurationTitle": "期間",
  "UserQuery": "ユーザークエリ",
  "ShowUserActions": "ユーザーアクションを表示",
  "NoData": "データがありません",
  "EventType": "イベントタイプ",
  "GoToFullSearch": "完全検索",
  "GoToEdition": "パネルをカスタマイズする",
  "RemoveContext": "コンテキストの削除",
  "BoxAttachToCase": "ケースに添付",
  "AttachToCase": "ケースに添付",
  "Attach": "添付",
  "Attached": "添付済み",
  "Detach": "添付解除",
  "Details": "詳細",
  "AdditionalFilters": "追加のフィルタ",
  "SelectNonContextualSearch": "現在の記録から",
  "CopyPasteToSupport": "このメッセージをコピー＆ペーストして、Coveoサポートチームに詳細について問い合わせます。",
  "FollowQueryDescription": "このクエリの検索結果に変更があった場合にアラートを送信してください。",
  "SearchAlerts_Panel": "アラートの管理",
  "SearchAlerts_PanelDescription": "検索アラートの表示と管理を行います。",
  "SearchAlerts_PanelNoSearchAlerts": "サブスクリプションがありません。",
  "SearchAlerts_Fail": "検索アラートサービスは現在利用できません。",
  "SearchAlerts_Type": "タイプ",
  "SearchAlerts_Content": "内容",
  "SearchAlerts_Actions": "アクション",
  "EmptyQuery": "<空>",
  "SearchAlerts_Type_followQuery": "クエリ",
  "SearchAlerts_Type_followDocument": "項目",
  "SearchAlerts_unFollowing": "フォローの停止",
  "SearchAlerts_follow": "フォロー",
  "SearchAlerts_followed": "フォロー済み",
  "SearchAlerts_followQuery": "クエリのフォロー",
  "Subscription_StopFollowingQuery": "クエリのフォローを停止",
  "SearchAlerts_Frequency": "日時",
  "SubscriptionsManageSubscriptions": "アラートの管理",
  "SubscriptionsMessageFollowQuery": "クエリ<b>{0}</b>が新規または更新済み項目を返した時にアラートを受信します。",
  "SubscriptionsMessageFollow": "項目<b>{0}</b>への変更についてのアラートを受信します。",
  "Expiration": "有効期限",
  "Monthly": "毎月",
  "Daily": "毎日",
  "Monday": "月曜日",
  "Tuesday": "火曜日",
  "Wednesday": "水曜日",
  "Thursday": "木曜日",
  "Friday": "金曜日",
  "Saturday": "土曜日",
  "Sunday": "日曜日",
  "NextDay": "来週の{0}",
  "LastDay": "先週の{0}",
  "StartTypingCaseForSuggestions": "ソリューションを表示するために問題について説明してください",
  "ExportToExcel": "Excelにエクスポート",
  "ExportToExcelDescription": "検索結果をExcelにエキスポート",
  "CaseCreationNoResults": "推奨ソリューションが見つかりませんでした",
  "SortBy": "並べ替え順",
  "BoxCreateArticle": "記事を作成する",
  "Facets": "ファセット",
  "AdvancedSearch": "高度検索",
  "Keywords": "キーワード",
  "AllTheseWords": "すべての言葉",
  "ExactPhrase": "完全に一致するフレーズ",
  "AnyOfTheseWords": "いずれかの言葉",
  "NoneOfTheseWords": "いずれの言葉も含まない",
  "Anytime": "随時",
  "InTheLast": "過去",
  "Days": "日",
  "Months": "月",
  "Month": "月",
  "Year": "年",
  "Between": "期間",
  "Language": "言語",
  "Size": "サイズ",
  "AtLeast": "最小",
  "AtMost": "最大",
  "Contains": "次を含む：",
  "DoesNotContain": "次の値を含まない",
  "Matches": "一致",
  "Bytes": "バイト",
  "card": "カード",
  "table": "表",
  "ResultLinks": "結果のリンク",
  "EnableQuerySyntax": "クエリ構文を有効にする",
  "On": "オン",
  "Off": "オフ",
  "Automatic": "自動",
  "ResultsPerPage": "ページごとの結果",
  "PreviousMonth": "前月",
  "NextMonth": "来月",
  "Title": "表題",
}

  var locales = String["locales"] || (String["locales"] = {});
  locales["ja"] = merge(locales["ja"], dict);
  String["toLocaleString"].call(this, { "ja": dict });
  String["locale"] = "ja";
  String["defaultLocale"] = "en";
  Globalize.culture("ja")
}